/* Antarmuka dengan Sensor Cahaya Analog - Trainer Internet of Things
 * Project : IoT Light Meter dengan Sensor Cahaya Analog
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP8266 WiFi dan Firebase ESP8266
#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>
// Library LCD 16x2 I2C
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// PIN Sensor Cahaya LDR/PD terhubung ke PIN A0 NodeMCU
#define LS  A0

// Firebase objek dengan nama fbdo
FirebaseData fbdo;
// LCD Objek dengan nama lcd, alamat I2C 0x27, karakter 16x2
LiquidCrystal_I2C lcd(0x27,16,2);

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

// Variabel untuk menyimpan data ADC dan data konversi sensor  
int ls_adc, ls_value;
// Variabel untuk menyimpan karakter data sensor
char ls_data[3];

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);
  
  lcd.init();       // Inisialisasi LCD
  lcd.backlight();  // Menyalakan Backlight LCD
  // Menampilkan Teks pada LCD
  lcd.setCursor(0,0); lcd.print("Trainer Kit IoT");  
  lcd.setCursor(0,1); lcd.print("Connecting-WiFi");
  
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);

  delay(2000);      // Jeda tampilan teks pada LCD
  lcd.clear();      // Membersihkan tampilan LCD
}

void loop() { 
  // Membaca data ADC sensor
  // ADC disimpan pada 'ls_adc'
  // Data konversi disimpan pada 'ls_value'
  ls_adc   = analogRead(LS);
  ls_value = map(ls_adc, 0, 1024, 0, 100);

  // Mencetak data pada serial monitor
  Serial.print("Cahaya : " + String(ls_value) + " %");
  Serial.println();

  // Mengirim data sensor ke database
  // dengan alamat */user/gauge1
  Firebase.setInt(fbdo, "/" + user + "/gauge1", ls_value);
  
  // Mencetak data sensor pada LCD 16x2 I2C
  lcd.setCursor(0, 0);
  lcd.print("Light Sensor (%)");
  lcd.setCursor(0, 1);
  sprintf(ls_data, "LS: %3d", ls_value);
  lcd.print(ls_data);
  
  // Jeda 150 ms agar perubahan nilai lebih halus 
  delay(150); 
}
